#include <gl\glaux.h>	
#include <gl\glut.h>

#include <stdio.h>		
#include <math.h>			
#include "model.h"	

char* worldfile = "..\\data\\world.txt";

GLfloat	xrot;			// X Rotation
GLfloat	yrot;			// Y Rotation
GLfloat lookupdown = 0.0f;			// fel-le nzsi irny
float heading, xpos, zpos;
float fFloorOffset = -0.25f;		// a kamera talajtl val tvolsga

const float piover180 = 0.0174532925f; //pi/180

GLfloat LightAmbient[]=		{ 0.5f, 0.5f, 0.5f, 1.0f };		// Ambient Light
GLfloat LightDiffuse[]=		{ 1.0f, 1.0f, 1.0f, 1.0f };		// Diffuse Light
GLfloat LightPosition[]=	{ 0.0f, 0.0f, 2.0f, 1.0f };		// Light Position

GLuint filter;				// textura filter
GLuint texture[3];		// textura

SECTOR sector;				// plya

//
// v1 es v2 vektorialis szorzata nn be kerul
//
void CalculateCross(float *v1, float *v2, float *nn)
	{
	float nx,ny,nz;
	nx = (v1[1]*v2[2]) - (v2[1]*v1[2]);
	ny = -((v1[0]*v2[2]) - (v2[0]*v1[2]));
	nz = (v1[0]*v2[1]) - (v2[0]*v1[1]);
	
	float d = 1.0f / (float)sqrt(nx * nx + ny * ny + nz * nz);
	
	nn[0] = nx*d;
	nn[1] = ny*d;
	nn[2] = nz*d;
	}
// 
// Ax + By + Cz + D = 0; alapjn a D kiszmtsa
// D = -Ax - By - Cz
//
void CalculateD(TRIANGLE *triangle)
	{
	triangle->d = - triangle->normal[0] * triangle->vertex[0].v[0]
					 - triangle->normal[1] * triangle->vertex[0].v[1]
					 - triangle->normal[2] * triangle->vertex[0].v[2];
	}
//
// hrom pontbl a normlvektor kiszmtsa
// a hrom pont a hromszg hrom cscspontjt jelenti
//
void CalculateNormalVectorFloat(float *p, float *nn)
	{
	float nx,ny,nz;
	float v1[3],v2[3];
	float d;
	
	v1[0] = p[3]-p[0];v1[1] = p[4]-p[1]; v1[2] = p[5]-p[2];
	v2[0] = p[6]-p[0];v2[1] = p[7]-p[1]; v2[2] = p[8]-p[2];
	
	nx = (v1[1]*v2[2]) - (v2[1]*v1[2]);
	ny = -((v1[0]*v2[2]) - (v2[0]*v1[2]));
	nz = (v1[0]*v2[1]) - (v2[0]*v1[1]);
	
	d = 1.0f / (float)sqrt(nx * nx + ny * ny + nz * nz);
	
	nn[0] = nx*d;
	nn[1] = ny*d;
	nn[2] = nz*d;
	}

//
// plya felolvassa fjlbl
//
void readstr(FILE *f,char *string)
	{
	do
		{
		fgets(string, 255, f);
		}
		while ((string[0] == '/') || (string[0] == '\n'));
	return;
	}

void SetupWorld()
	{
	float x, y, z, u, v;
	int numtriangles;
	FILE *filein;
	char oneline[255];
	filein = fopen(worldfile, "rt");

	readstr(filein,oneline);
	sscanf(oneline, "NUMPOLLIES %d\n", &numtriangles);

	sector.triangle = new TRIANGLE[numtriangles];
	sector.numtriangles = numtriangles;
	
	float vertex[9];
		
	for (int loop = 0; loop < numtriangles; loop++)
		{
		int i = 0;
		for (int vert = 0; vert < 3; vert++)
			{
			readstr(filein,oneline);
			sscanf(oneline, "%f %f %f %f %f %f %f", &x, &y, &z, &u, &v);
			sector.triangle[loop].vertex[vert].v[0] = x; 
			vertex[i] = x;
			sector.triangle[loop].vertex[vert].v[1] = y;
			vertex[i + 1] = y;
			sector.triangle[loop].vertex[vert].v[2] = z;
			vertex[i + 2] = z;
			i += 3;
			//
			// textura koordinata kiszmtsa
			//
			sector.triangle[loop].vertex[vert].t[0] = u;
			sector.triangle[loop].vertex[vert].t[1] = v;
			}
		//
		// Ax+By+Cz+D=0 alapjn A,B,C kiszmtsa
		//
		CalculateNormalVectorFloat(vertex,sector.triangle[loop].normal);
		//
		// majd D kiszmtsa
		//
		CalculateD(&sector.triangle[loop]);
		}
	fclose(filein);
	return;
	}
//
// Load Bitmaps And Convert To Textures
//
GLvoid LoadGLTextures()
	{
	//
	// Load Texture
	//
	AUX_RGBImageRec *texture1;

	texture1 = auxDIBImageLoad("../Data/mud.bmp");
	
	if (!texture1)
		{
		printf("Could not load textures");
		exit(1);
		}

	// Create Nearest Filtered Texture
	glGenTextures(3, &texture[0]);
	glBindTexture(GL_TEXTURE_2D, texture[0]);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);
	glTexImage2D(GL_TEXTURE_2D, 0, 3, texture1->sizeX, texture1->sizeY, 0, GL_RGB, GL_UNSIGNED_BYTE, texture1->data);

	// Create Linear Filtered Texture
	glBindTexture(GL_TEXTURE_2D, texture[1]);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexImage2D(GL_TEXTURE_2D, 0, 3, texture1->sizeX, texture1->sizeY, 0, GL_RGB, GL_UNSIGNED_BYTE, texture1->data);

	// Create MipMapped Texture
	glBindTexture(GL_TEXTURE_2D, texture[2]);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_NEAREST);
	gluBuild2DMipmaps(GL_TEXTURE_2D, 3, texture1->sizeX, texture1->sizeY, GL_RGB, GL_UNSIGNED_BYTE, texture1->data);
	};

void InitGL()	
	{
	LoadGLTextures();								// Load The Texture(s)
	glEnable(GL_TEXTURE_2D);					// Enable Texture Mapping

	glBlendFunc(GL_SRC_ALPHA,GL_ONE);		// Set The Blending Function For Translucency
	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);	// This Will Clear The Background Color To Black
	glClearDepth(1.0);							// Enables Clearing Of The Depth Buffer
	glDepthFunc(GL_LESS);						// The Type Of Depth Test To Do
	glEnable(GL_DEPTH_TEST);					// Enables Depth Testing
	glShadeModel(GL_SMOOTH);					// Enables Smooth Color Shading

	glLightfv(GL_LIGHT1, GL_AMBIENT, LightAmbient);
	glLightfv(GL_LIGHT1, GL_DIFFUSE, LightDiffuse);
	glLightfv(GL_LIGHT1, GL_POSITION,LightPosition);
	glEnable(GL_LIGHT1);
	}

void ReSizeGLScene(GLsizei Width, GLsizei Height)
	{
	glViewport(0, 0, Width, Height);			

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	gluPerspective(45.0f, (GLfloat)Width / (GLfloat)Height, 0.1f, 100.0f);

	glMatrixMode(GL_MODELVIEW);
	}

GLvoid DrawGLScene(GLvoid)
	{
	GLfloat xtrans, ztrans, ytrans;
	GLfloat sceneroty;

	xtrans = -xpos;
	ztrans = -zpos;
	ytrans = fFloorOffset; // a fold felett egy kicsivel mozgunk

	sceneroty = 360.0f - yrot;
	
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);		// Clear The Screen And The Depth Buffer
	glLoadIdentity();
	//
	// viewpoint transformci
	//
	glRotatef(lookupdown,1.0f, 0.0f, 0.0f);
	glRotatef(sceneroty, 0.0f, 1.0f, 0.0f);
	
	glTranslatef(xtrans, ytrans, ztrans);

	glBindTexture(GL_TEXTURE_2D, texture[filter]);
	
	glBegin(GL_TRIANGLES);
	
	for (int loop_m = 0; loop_m < sector.numtriangles; loop_m++)
		{
		glTexCoord2fv(&sector.triangle[loop_m].vertex[0].t[0]); 
		glVertex3fv(&sector.triangle[loop_m].vertex[0].v[0]);
			
		glTexCoord2fv(&sector.triangle[loop_m].vertex[1].t[0]); 
		glVertex3fv(&sector.triangle[loop_m].vertex[1].v[0]);
			
		glTexCoord2fv(&sector.triangle[loop_m].vertex[2].t[0]); 
		glVertex3fv(&sector.triangle[loop_m].vertex[2].v[0]);
		}

	glEnd();

	glutSwapBuffers();
	}

int ox = 0;
int oy = 0;
int moving;

bool bMouseDown = false;

void motion(int x, int y)
	{
	if (moving) 
		{
		heading += (ox - x);
		lookupdown -= (oy - y);
		yrot = heading;							
				
		ox = x;	// save positions
		oy = y;
		
		glutPostRedisplay();
		}
	}

void mouse(int button, int state, int x, int y) 
	{
	if (button == GLUT_LEFT_BUTTON && state == GLUT_DOWN)
		{
		moving = 1;
		ox = x;	// save new positions
		oy = y;
		}

	if (button == GLUT_LEFT_BUTTON && state == GLUT_UP) 
		{
		moving = 0;
		}
	}

void keyboard(unsigned char key, int x, int y)
	{
   switch (key) 
		{
		case 'w':
				{
				xpos -= (float)sin(heading*piover180) * 0.08f;
				zpos -= (float)cos(heading*piover180) * 0.08f;
				break;
				}

		case 's':
				{
				xpos += (float)sin(heading*piover180) * 0.08f;
				zpos += (float)cos(heading*piover180) * 0.08f;		
				break;
				}

		case 'd':
				{
				//
				// ugyanaz mint 'w' esetn csak merleges vektort kpzek
				//
				xpos += (float)cos(heading*piover180) * 0.08f;
				zpos -= (float)sin(heading*piover180) * 0.08f;
				break;
				}

		case 'a':
				//
				// ugyanaz mint 's' esetn csak merleges vektort kpzek
				//
				{
				xpos -= (float)cos(heading*piover180) * 0.08f;
				zpos += (float)sin(heading*piover180) * 0.08f;		
				break;
				}
			}
	glutPostRedisplay();	
	}

int main()
	{
   glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB);
   glutInitWindowSize (500, 500); 
   glutCreateWindow ("My Doom");
   glutDisplayFunc(DrawGLScene); 
	SetupWorld();
	InitGL();
   glutMouseFunc(mouse);
	glutMotionFunc(motion);
   glutReshapeFunc(ReSizeGLScene);
	glutKeyboardFunc(keyboard);
   glutMainLoop();
   return 0;
	}




